<?php
/**
 * tools-for-your-hobby
 * https://www.tfyh.org
 * Copyright  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

use tfyh\control\Monitor;
use tfyh\control\Runner;

// include statements are inserted later for performance reasons

const HITS_PER_SECOND_MAX = 2.0;
// ===== Redirect in case of maintenance
$maintenanceUntil = ""; // e.g.: $maintenance_until = "31.1.2021, 18:00h";
if (strlen($maintenanceUntil) > 3)
    header("Location: ../_Control/maintenance.php?until=" . urlencode($maintenanceUntil));

// ===== set session type
// the $userRequestedFile must be set by the calling page. __FILE__ would point to this "init.php" here.
global $userRequestedFile;
if (! isset($userRequestedFile)) {
    echo "Fatal error in init.php. \$userRequestedFile is not set. Aborting.";
    exit();
}
$sessionType = (str_ends_with($userRequestedFile, "post_tx.php")) ? "api" : "web";

// ===== Set PHP error reporting.
$cwd = getcwd();
$errorFile = substr($cwd, 0, strrpos($cwd, "/")) . "/Log/php_error.log";
if (file_exists($errorFile) && (filesize($errorFile) > 200000)) {
    copy($errorFile, $errorFile . ".previous");
    file_put_contents($errorFile, "[continued]\n");
}
if ($_SERVER["HTTP_HOST"] == "localhost")
    error_reporting(E_ERROR | E_WARNING);
else
    error_reporting(E_ERROR);
ini_set("error_log", $errorFile);

// ===== start the Monitor and throttle to prevent from machine attacks.
include_once '../_Control/Monitor.php';
$monitor = Monitor::getInstance($sessionType);
$monitor->throttle(false, HITS_PER_SECOND_MAX);

// ===== instantiate the Runner for script execution control: session, database connector etc.
// ===== This essentially loads the whole application including the i18n support.
include_once '../_Control/Runner.php';
$runner = Runner::getInstance();

// register the shutdown function to be able to log preemptive script abortion.
function shutdown(): void { Runner::getInstance()->shutdown(); }
register_shutdown_function('shutdown');

// ===== initialisation finished. Start script execution
$runnerTime = microtime(true);
$runner->startScript($userRequestedFile);
file_put_contents("../Log/runnerTimes.log", (microtime(true) - $runnerTime) . "\n", FILE_APPEND);
