<?php
/**
 * tools-for-your-hobby
 * https://www.tfyh.org
 * Copyright  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

namespace tfyh\data;

enum ParserName: String {
    case BOOLEAN = "boolean";
    case INT = "int";
    case INT_LIST = "int_list";
    case LONG = "long";
    case DOUBLE = "double";
    // native numeric
    case DATE = "date";
    case DATETIME = "datetime";
    // native LocalDate, LocalDateTime
    case TIME = "time"; // native int
    case STRING = "string"; // native String. No parsing, no formatting applied
    case STRING_LIST = "string_list"; // native String. No parsing, no formatting applied
    case NONE = "none"; // no value accepted, will always parse to ""
    // case NONE is used within the descriptor definition to reference to the value parser as
    // parser for the properties default_value, value_min, and value_max which is not fix
    // like the parser for all other properties.

    public static function valueOfOrNone(?String $name): ParserName {
        return (!is_null($name)) ? (ParserName::from(strtolower($name)) ?? ParserName::NONE) : ParserName::NONE;
    }
    public static function isList(ParserName $parserName): bool {
        return ($parserName == self::INT_LIST) || ($parserName == self::STRING_LIST);
    }
}