<?php

namespace tfyh\util;

include_once "../_Util/LanguageSettings.php";

enum Language: string
{
    case EN = "en";
    case DE = "de";
    case FR = "fr";
    case IT = "it";
    case NL = "nl";
    case CSV = "csv";
    case SQL = "sql";

    public static function settingsOf(Language $language): LanguageSettings
    {
        return match ($language) {
            Language::EN => new LanguageSettings("en", "d-m-Y", true),
            Language::DE => new LanguageSettings("de", "d.m.Y", false),
            Language::FR => new LanguageSettings("fr", "d/m/Y", true),
            Language::IT => new LanguageSettings("it", "d/m/Y", true),
            Language::NL => new LanguageSettings("nl", "d-m-Y", false),
            Language::CSV => new LanguageSettings("csv", "Y-m-d", true),
            Language::SQL => new LanguageSettings("sql", "Y-m-d", true)
        };
    }

    public static function valueOfOrDefault(string $name): Language
    {
        return Language::tryFrom(strtolower($name)) ?? Language::DE;
    }

}