<?php
namespace tfyh\util;

use TCPDF;
include_once "../Tcpdf/tcpdf.php";

class PdfAdapted extends TCPDF
{
    public string $footerText;

    // Page footer
    public function Footer(): void
    {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10,
            $this->footerText . "         " . $this->getAliasNumPage() .
            '/' . $this->getAliasNbPages(), 0, false, 'C', 0);
    }
}
