<?php
/**
 * tools-for-your-hobby
 * https://www.tfyh.org
 * Copyright  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Simple display page. Shows all recent activities.
 */

use tfyh\control\Monitor;
use tfyh\control\Runner;
include_once "../_Control/Runner.php";

use tfyh\util\I18n;
include_once "../_Util/I18n.php";

// ===== initialize
$userRequestedFile = __FILE__;
include_once "../_Control/init.php";
$runner = Runner::getInstance();
$i18n = I18n::getInstance();

// ===== start page output
echo $runner->pageStart();

echo "<h3>" . $i18n->t("l5E880|Access statistics") . "</h3>";
echo "<p><b>" .
         $i18n->t("7HfELM|Table of user-driven act...") . ":</b> " .
         $i18n->t("KdLw1V|page calls (init), error...") . "</p>";
// show activities summary last two weeks.
$monitor = Monitor::getInstance("web");
echo $monitor->activitiesToHtml();
echo "<!-- END OF Content -->\n</div>";
$runner->endScript();
