<?php
/**
 * tools-for-your-hobby
 * https://www.tfyh.org
 * Copyright  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */


use tfyh\control\Runner;
use tfyh\control\Users;
include_once "../_Control/Runner.php";
include_once "../_Control/Users.php";

use tfyh\data\Config;
use tfyh\data\DatabaseConnector;
use tfyh\data\Indices;
use tfyh\data\Item;
use tfyh\data\Record;
include_once "../_Data/Config.php";
include_once "../_Data/DatabaseConnector.php";
include_once "../_Data/Record.php";

use tfyh\util\I18n;
use tfyh\util\Language;
use tfyh\util\ListHandlerKernel;

include_once "../_Util/I18n.php";
include_once "../_Util/Language.php";

/**
 * Generic record display file.
 */

// ===== initialize
$userRequestedFile = __FILE__;
include_once "../_Control/init.php";
$runner = Runner::getInstance();
$dbc = DatabaseConnector::getInstance();
$i18n = I18n::getInstance();
$config = Config::getInstance();
$language = $config->language();

$uid = (isset($_GET["uid"])) ? $_GET["uid"] : false;
$uuid = (isset($_GET["uuid"])) ? $_GET["uuid"] : false;
$errors = (($uuid === false) && ($uid === false))
    ? $i18n->t("GIYKaI|You have to provide an i...") : "";
$tablesItem = Config::getInstance()->getItem(".tables");

if (strlen($errors) == 0) {
    $indices = Indices::getInstance();
    $indices->addAll();
    $ownObjectName = ($uuid) ? $indices->getNameForUuid($uuid) : false;
    $ownRecordName = ($uid) ? $indices->getNameForUid($uid) : false;
    $ownTableName = ($uuid) ? $indices->getTableForUuid($uuid) : (($uid) ? $indices->getTableForUid($uid) : "??");
    if (strlen($ownTableName) == 0)
        $errors .= $i18n->t("peiDrk|For your uuid no tabke c...");
    else {
        $ownKeyField = ($uuid) ? "uuid" : (($uid) ? "uid" : "??");
        $ownKeyValue = ($uuid) ?: (($uid) ?: "??");

        $ownRecordItem = $tablesItem->getChild($ownTableName);
        $ownRecord = new Record($ownRecordItem);
        $ownRecordSql = DatabaseConnector::getInstance()->find($ownTableName, $ownKeyField, $ownKeyValue);
        $ownRecord->parse($ownRecordSql, $language);
    }
}

/**
 * Create the definition for a dynamic list which retrieves the information needed for a occurrence check in table .
 */
function createUuidSearchListDefinition(Item $recordItem, String $searchedId): String {
    $tableName = $recordItem->name();
    $listDefinition = "id;permission;name;label;select;table;where;options\n";
    $listDefinition .= "1;analyst;index;autogenerated search support list;";
    $selectString = "uid";
    $record = new Record($recordItem);
    $nameColumns = $record->templateFields("full");
    $whereStr = "";
    foreach ($recordItem->getChildren() as $columnItem)
        if (str_contains($columnItem->type()->name(), "uuid")) {
            $selectString .= "," . $columnItem->name();
            $whereStr .= " OR `" . $columnItem->name() . "` LIKE '%" . $searchedId . "%'";
        } elseif (in_array($columnItem->name(), $nameColumns))
            $selectString .= "," . $columnItem->name();
    // stop here, if there is not uid/uuid provided, like in system tables (archive, changes, trash)
    if ($selectString == "uid")
        return "";
    $listDefinition .= $selectString . ";$tableName;" . substr($whereStr, 4) . ";";
    return $listDefinition;
}

$dbc = DatabaseConnector::getInstance();
$searchResult = [];
if ($uuid !== false) {
    foreach ($tablesItem->getChildren() as $recordItem) {
        $listDefinition = createUuidSearchListDefinition($recordItem, substr($uuid, 0, 11));
        if (strlen($listDefinition) > 0) {
            $searchResult[$recordItem->name()] = [];
            $record = new Record($recordItem);
            $listHandlerKernel = new ListHandlerKernel("@dynamic", $listDefinition);
            $rows = $listHandlerKernel->getRows("csv");
            foreach ($rows as $row) {
                $record->parse($row, Language::CSV);
                $full = $record->recordToTemplate("full");
                $searchResult[$recordItem->name()][] = $row["uid"] . " " . $full;
            }
        }
    }
}
// TODO for uid

// ===== start page output
echo $runner->pageStart();

if (strlen($errors) > 0)
    echo $errors;
else {
    echo "<h3>" . $i18n->t("Qn9X22|Occurrences of %1", $ownTableName,
            $ownRecord->recordToTemplate("name")) . "</h3>";
    echo "<p>" . $i18n->t("Xl2t9D|Summary") . ": " . $ownRecord->recordToTemplate("full") . "</p>";
    foreach($searchResult as $tableName => $records) {
        if (count($records) > 0) {
            echo "<h4>" . $tableName . "</h4><ol>";
            foreach($records as $record) {
                $uid = substr($record, 0, 8);
                echo "<li><a target='_blank' href='../_pages/viewRecord.php?table=$tableName&uid=$uid'>" . substr($record, 9) . "</a></li>";
            }
            echo "</ol>";
        }
    }
}
echo "</div>";
$runner->endScript();
