<?php

use tfyh\api\Container;
use tfyh\api\ResultForContainer;
include_once "../_Api/Container.php";
include_once "../_Api/ResultForContainer.php";

use app\TxHandler;
include_once "../App/TxHandler.php";

use tfyh\control\LoggerSeverity;
use tfyh\control\Monitor;
use tfyh\control\Runner;
include_once "../_Control/LoggerSeverity.php";
include_once "../_Control/Monitor.php";
include_once "../_Control/Runner.php";

// ===== initialize the session type to api
$monitor = Monitor::getInstance("api");
$runner = Runner::getInstance();
if ($runner->debugOn)
    $runner->logger->log(LoggerSeverity::DEBUG, "post_tx.php", "Request handling started at " . date("H:i:s"));

// ===== parse tx container and return, if parsing errors occur
$txc = (isset($_POST["txc"])) ? trim($_POST["txc"]) : "";
$container = Container::getInstance();
$container->parseRequest(trim($txc));
if ($container->txc["containerResultCode"] >= 40)
    $container->sendResponseAndExit();

// ===== now start the script execution. Since the $runner and $monitor are singleton classes, the normal script start
// ===== can be called.
$userRequestedFile = __FILE__;
include_once "../_Control/init.php";

// ===== handle all transactions
$tx_handler = new TxHandler();
$tx_handler->handleRequestContainer($runner->menu);
if ($runner->debugOn)
    $runner->logger->log(LoggerSeverity::DEBUG, "post_tx.php", "Request handling completed at " . date("H:i:s"));
$container->sendResponseAndExit();
