const Language = Object.freeze({
    EN: "en",
    DE: "de",
    FR: "fr",
    IT: "it",
    NL: "nl",
    CSV: "csv",
    SQL: "sql",

    settingsOf: function(language)
    {
        switch (language) {
            // NB: The date template is ignored, because Javascript uses its own in the Date.prototype.toLocaleDateString()
            case Language.EN: return new LanguageSettings("en", "d-m-Y", true);
            case Language.DE: return new LanguageSettings("de", "d.m.Y", false);
            case Language.FR: return new LanguageSettings("fr", "d/m/Y", true);
            case Language.IT: return new LanguageSettings("it", "d/m/Y", true);
            case Language.NL: return new LanguageSettings("nl", "d-m-Y", false);
            case Language.CSV: return new LanguageSettings("csv", "Y-m-d", true);
            case Language.SQL: return new LanguageSettings("sql", "Y-m-d", true);
            default: return new LanguageSettings("en", "Y-m-d", true);
        }
    },

    // name String to PropertyName resolution function
    valueOfOrDefault: function(name) {
        for (let language of Object.keys(Language))
            if (name === Language[language])
                return Language[language]
        return Language.DE
    }

});