/**
 * The local storage provides a container for String items like the JavaScript window.localStorage,
 * but provides no persistence in Web and mobile.
 */
class LocalCache {

    static #instance = new LocalCache()
    static getInstance() { return this.#instance; }

    getItem(key) { return window.localStorage.getItem(key) }
    setItem(key, value) { window.localStorage.setItem(key, value) }
    removeItem(key) { window.localStorage.removeItem(key) }
    clear() { window.localStorage.clear() }
    keys() {
        let keys = []
        for (let i = 0; i < window.localStorage.length; i++)
            keys.push(window.localStorage.key(i))
        return keys
    }
    init() {} // dummy for compatibility reasons.
}