<?php
/**
 * dilbo - digital logbook for Rowing and Canoeing
 * https://www.dilbo.org
 * Copyright:  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

use tfyh\api\Transactions;
include_once "../_Api/Transactions.php";

use tfyh\control\Monitor;
use tfyh\control\Runner;
include_once "../_Control/Runner.php";

use tfyh\data\Config;
include_once "../_Data/Config.php";

use tfyh\util\I18n;
use tfyh\util\ListHandler;
include_once "../_Util/I18n.php";
include_once "../_Util/ListHandler.php";

/**
 * The start of the session after successful login.
 */

// ===== initialize
$userRequestedFile = __FILE__;
include_once "../_Control/init.php";
$config = Config::getInstance();
$language_code = $config->language()->value;
$runner = Runner::getInstance();
$i18n = I18n::getInstance();
$monitor = Monitor::getInstance();

$userRole = $runner->sessions->userRole();
$isAdmin = ($runner->sessions->userRole() == "admin");

// ==== check for updates
$version_notification = "";
if ($isAdmin) {
    $ownVersion = $config->appVersion;
    $appUrl = $config->appUrl;
    // the currentApplicationVersion file is updated during the cron jobs.
    $serverVersion = file_get_contents("../Log/currentApplicationVersion");
    if ($serverVersion != $ownVersion)
        $version_notification = "<b>" . $i18n->t("p71s5H|Note:") . "</b> " .
            $i18n->t("hYR1lf|A more recent program ve...", $serverVersion) . " =&gt; " .
            "<a href='../_pages/upgrade.php'>" . $i18n->t("7lipsQ|UPGRADE") . "</a></b>";
    else
        $version_notification = $i18n->t("Vhea3D|Your server application ...");
}
$openTrips = new ListHandler("logbook", "open_trips", [
    "{logbookname}" => $config->getItem(".app.user_preferences.logbook")->valueCsv()]
);
$logbookItem = $config->getItem(".tables.logbook");
$openTripsTable = "<table>";
$openTripsTable .= "<tr><th>" . $logbookItem->getChild("number")->label() . "</th>";
$openTripsTable .= "<th>" . $logbookItem->getChild("start")->label() . "</th>";
$openTripsTable .= "<th>" . $logbookItem->getChild("asset_uuid")->label() . "</th>";
$openTripsTable .= "<th>" . $logbookItem->getChild("destination")->label() . "</th></tr>";
$logbookRows = $openTrips->getRows("referenced");
foreach($logbookRows as $logbookRow) {
    $openTripsTable .= "<tr><td>" . $logbookRow["number"] . "</td>";
    $openTripsTable .= "<td>" . $logbookRow["start"] . "</td>";
    $openTripsTable .= "<td>" . $logbookRow["asset_uuid"] . "</td>";
    $openTripsTable .= "<td>" . $logbookRow["destination"] . "</td></tr>";
}
$openTripsTable .= "</table>";

// ===== start page output
echo $runner->pageStart();

echo "<h3>" . $i18n->t("g6ljZr|dilbo home for %1", $runner->sessions->userFullName()) . "</h3>";
echo "<p>userId: " . $runner->sessions->userId() . ", ";
echo "e-Mail: " . $runner->sessions->userMail() . ".<br>";
echo $version_notification . "</p>";
echo "<h4>" . $i18n->t("cDfe5p|Boats underway") . "</h4>";
echo (count($logbookRows) == 0) ? "---" : $openTripsTable;
echo "<h4>" . $i18n->t("Z4VNs0|Active clients") . "</h4>" . Transactions::getLastAccessesApi();
echo "</div>";
$runner->endScript();
