<?php
/**
 * dilbo - digital logbook for Rowing and Canoeing
 * https://www.dilbo.org
 * Copyright:  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

use tfyh\control\Runner;
include_once "../_Control/Runner.php";

use tfyh\util\I18n;
include_once "../_Util/I18n.php";

/**
 * The start of the web application after successful login.
 */

// ===== initialize
$userRequestedFile = __FILE__;
include_once "../_Control/init.php";
$runner = Runner::getInstance();
$i18n = I18n::getInstance();

// ===== start page output
echo file_get_contents('../Config/snippets/page_01_start_web_app');

// ===== add div for application dock
echo "  <!-- The Main -->\n";
echo "<!-- This will be the entire page. Fill tfyhMain by the application -->\n";
echo "  <div id='tfyhMain'>\n";
echo "  </div>\n\n";
echo "<div><img class='centered' src='../resources/appLogo.png' id='app-load' alt='animated logo' style='width:128px'></div>";

// ===== forward the user record (partly) script variable
$user_data_fields = ["uid","uuid","first_name","last_name","name_affix","title","gender","birthday",
        "association","status","boat_usage_ban","user_id","role","subscriptions","workflows","concessions",
        "preferences"
];
$user_record = "\n<script>const php_user_record = '";
foreach ($user_data_fields as $user_data_field)
    $user_record .= $user_data_field . "=" .
             ((isset($runner->users->session_user[$user_data_field])) ? str_replace("'", "°", 
                    $runner->users->session_user[$user_data_field]) : "") . "|";
$user_record = mb_substr($user_record, 0, mb_strlen($user_record) - 1) . "';</script>";
echo $user_record;

// ===== create an API session and forward the API session id
$api_session_started = $runner->sessions->sessionStart(0, true);
if ($api_session_started) {
    $api_session_id = $runner->sessions->sessionId();
    echo "\n<script>const php_api_session_id = '" . $api_session_id . "';</script>";
}

// ===== end script and send the footer
$runner->endScript();