<?php
/**
 * dilbo - digital logbook for Rowing and Canoeing
 * https://www.dilbo.org
 * Copyright:  2023-2025  Martin Glade
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

use tfyh\control\Runner;
include_once "../_Control/Runner.php";

use tfyh\data\Config;
include_once "../_Data/Config.php";

/**
 * The data privacy declaration page.
 */

// ===== initialize toolbox and socket and start session.
$userRequestedFile = __FILE__;
include_once "../_Control/init.php";
$language = Config::getInstance()->language()->value;

// ===== start page output
echo Runner::getInstance()->pageStart();

echo file_get_contents("../Texts/$language/about.html");

Runner::getInstance()->endScript();